# 无影 DiT 优化节点使用文档

## 一、安装方式

1.  解压 wuyingDiT 压缩包，将 wuyingDiT 文件夹移动至 ComfyUI 目录下的 custom\_nodes 文件夹
2.  安装所需的 Python 依赖（`pip install -r requirements.txt`）
    

## 二、使用方式

### 单卡优化

*   工作流参考 wuyingDiT/example\_workflows 目录下的 wuyingDiT\_single\_\*.json 文件
    

#### 单卡优化节点使用示例

1.  在节点库中搜索 “wuyingOptim”，并拖动优化节点到工作流画布  
    ![wuying_optim](resources/wuyingOptim_node.png)
    
2.  在节点中按需设置相关参数，参数含义如下  
    ![参数设置](resources/wuyingOptim_args.png)
    
    1.  model\_type：工作流中使用的模型种类
        
        1.  参数默认为 unknown，表示采用不指定模型的通用优化策略
            
        2.  支持手动选择指定的模型种类，选择后将匹配对应的定制优化策略，提供更强的优化能力
            
    2.  optimization\_level：优化力度
        
        1.  参数默认为 20，表示在无损优化策略的基础上允许采用适当力度的有损优化策略
            
        2.  支持设置范围为 0 到 100，其中，0 表示仅采用无损优化， 1～100 表示允许有损优化，100 时优化力度最大
            
3.  串联优化节点到工作流中，串联位置在采样器之前  
    ![截屏2025-11-26 15.17.59.png](resources/wuyingOptim_link.png)
    

### 多卡优化
入口：ComfyUI>节点库>wuyingDiT>parallel

1. 配置多卡工作环境初始化：从左侧tab的节点库>wuyingDiT>parallel中，将“wuyingDiT Init Actors"节点拖出至工作区。多卡工作站支持在此节点上配置GPU参数2、4；单卡工作站不支持
2. 加载底模：将“parallel”文件夹下的“Load Diffusion Model(wuyingDiT)”节点拖出至工作区。在“Load Diffusion Model(wuyingDiT)”节点的unet_name中选择所需模型。将“wuyingDiT Init Actors"节点中的wuyingDiT_actors_init关联至“Load Diffusion Model(wuyingDiT)”节点。
3. 加载Lora模型【此步骤为非必操作项】：如为底模为LoRA模型时，将“parallel”文件夹下的“Load Lora Model(wuyingDiT)”节点拖出至工作区。在lora_name中选择所需模型。将此节点中的“wuyingDiT _lora”关联至“Load Diffusion Model(wuyingDiT)”节点中的“wuyingDiT _lora”。
4. 并行推理：将“parallel”文件夹下的“KSamplerAdvanced (wuyingDiT)”节点拖出至工作区。将“KSamplerAdvanced (wuyingDiT)”节点中的“dit_actors"关联至“Load Diffusion Model(wuyingDiT)”节点中的“dit_actors”
5. 配置其他非无影DiT节点的参数，点击运行。查看相应的视频、图片的质量。

</note> 工作流参考 wuyingDiT/example\_workflows 目录下的 wuyingDiT\_parallel\_\*.json 文件
    

## 三、适用范围

### GPU 适用性

*   当前仅支持在配置有 5880 GPU 的无影产品中使用
    

### 模型适用性

*   单卡优化
    
    *   适用于常见的图片生成、视频生成模型
        

*   多卡优化
    
    *   现阶段仅适用于 flux、qwen-image、wan、hunyuan 系列模型
        

### 工作流适用性

*   适用于 ComfyUI 官方工作流以及类似的自定义工作流
    
*   现阶段暂不支持例如 WanVideoWrapper 等第三方节点构成的工作流，支持工作进展中
    

## 四、请求无影加速（一键转换）

### 方式一：

使用下面的python脚本，读取本地工作流文件（如没有，可用附件示例），发送请求给服务，拿到并保存优化后的工作流。

`python3 convert.py /path/to/original_workflow.json -o /path/to/dst_workflow.json`

```python
import argparse
import json
import sys
from pathlib import Path

import requests


def transform_workflow(
    workflow_path: Path,
    server_url: str = "http://localhost:8188/workflow/transform",
    output_path: Path | None = None,
):
    # 读取本地 workflow json
    try:
        with workflow_path.open("r", encoding="utf-8") as f:
            workflow_data = json.load(f)
    except Exception as e:
        print(f"[ERROR] 读取工作流文件失败: {e}", file=sys.stderr)
        sys.exit(1)

    # 构造请求体：接口期望 {"workflow": <dict>}
    payload = {"workflow": workflow_data}

    try:
        resp = requests.post(server_url, json=payload, timeout=60)
    except Exception as e:
        print(f"[ERROR] 请求接口失败: {e}", file=sys.stderr)
        sys.exit(1)

    if resp.status_code != 200:
        print(f"[ERROR] HTTP {resp.status_code}: {resp.text}", file=sys.stderr)
        sys.exit(1)

    try:
        resp_json = resp.json()
    except Exception as e:
        print(f"[ERROR] 响应不是 JSON: {e}", file=sys.stderr)
        print(resp.text)
        sys.exit(1)

    # 简单检查 ok 字段
    if not resp_json.get("ok", False):
        print("[ERROR] 转换失败，服务返回：", file=sys.stderr)
        print(json.dumps(resp_json, ensure_ascii=False, indent=2))
        sys.exit(1)

    transformed_workflow = resp_json.get("workflow")
    conversion_result = resp_json.get("conversion_result")
    related_nodes_id = resp_json.get("related_nodes_id")

    print("转换成功")
    print(f"conversion_result: {conversion_result}")
    print(f"related_nodes_id: {related_nodes_id}")

    # 如果指定了输出文件，则写入
    if output_path:
        try:
            with output_path.open("w", encoding="utf-8") as f:
                json.dump(
                    transformed_workflow,
                    f,
                    ensure_ascii=False,
                    indent=2,
                )
            print(f"转换后的 workflow 已写入: {output_path}")
        except Exception as e:
            print(f"[ERROR] 写入输出文件失败: {e}", file=sys.stderr)
            sys.exit(1)
    else:
        # 否则直接打印到终端
        print("转换后的 workflow JSON:")
        print(json.dumps(transformed_workflow, ensure_ascii=False, indent=2))


def main():
    parser = argparse.ArgumentParser(
        description="调用 ComfyUI 自定义节点 /workflow/transform 进行工作流转换"
    )
    parser.add_argument(
        "input",
        type=str,
        help="输入工作流 JSON 文件路径",
    )
    parser.add_argument(
        "-o",
        "--output",
        type=str,
        help="转换后 workflow 的输出文件路径（不填则直接打印到终端）",
    )
    parser.add_argument(
        "-u",
        "--url",
        type=str,
        default="http://localhost:8188/workflow/transform",
        help="转换服务的 URL，默认: http://localhost:8188/workflow/transform",
    )

    args = parser.parse_args()

    input_path = Path(args.input)
    if not input_path.is_file():
        print(f"[ERROR] 找不到输入文件: {input_path}", file=sys.stderr)
        sys.exit(1)

    output_path = Path(args.output) if args.output else None

    transform_workflow(
        workflow_path=input_path,
        server_url=args.url,
        output_path=output_path,
    )


if __name__ == "__main__":
    main()
```

如果转换成功，则出现类似：

```python
conversion_result: SUCCEED
转换后的 workflow 已写入: xxx.json
```

如果转换失败，请考虑在ComfyUI前端手动配置。conversion\_result 字段说明：

| SUCCEED | SUCCEED\_UNKNOWN\_MODEL | FAILED | FAILURE\_ALREADY\_CONVERTED |
| --- | --- | --- | --- |
| 成功了 | 成功但是不知道模型 | 转换失败 | 已经是无影优化后的工作流 |

### 方式二：

进入comfyui web端，读取本地工作流（以附件示例original\_workflow.json为例），点击上方的“无影DiT加速推理”按钮

![conversion_button.png](resources/conversion_button.png)

点击后将在新窗口打开添加了WuyingOptim优化节点的工作流

![conversion_result](resources/conversion_result.png)

若该节点中的model\_type不符合实际模型的type，可以手动选择修改

![conversion_modify.png](resources/conversion_modify.png)
